<?php
declare(strict_types=1);

function json_input(): array {
  $raw = file_get_contents('php://input');
  if ($raw === false || trim($raw) === '') return [];
  $data = json_decode($raw, true);
  if (!is_array($data)) {
    api_error(400, 'Invalid JSON body');
  }
  return $data;
}

function api_json($data, int $code = 200): void {
  http_response_code($code);
  header('Content-Type: application/json; charset=utf-8');
  header('Cache-Control: no-store');
  echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
  exit;
}

function api_error(int $code, string $message, array $extra = []): void {
  api_json(array_merge(['ok' => false, 'error' => $message], $extra), $code);
}
